<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 13.01.14 12:44
 */

namespace VM\PackageGeneratorBundle\Services\Export;



use Symfony\Component\DependencyInjection\ContainerInterface;

class ExportProcessCreator
{
    /**
     * @var string
     */
    protected $dir = '/var/tmp/abc';


    /**
     * @var ContainerInterface
     */
    protected $Container;


    public function __construct(ContainerInterface $Container)
    {
        $this->Container = $Container;
    }


    /**
     * @param $path
     * @param $authCode
     * @param $outputPath
     * @param string $type
     * @param string $title
     * @param string $svnDir
     * @param bool $onlyContent
     * @return string
     */
    public function process($path, $authCode, $outputPath, $type = 'xml', $title = '', $svnDir = '', $onlyContent = true)
    {
        $packageDir = $this->dir . '/' . $authCode . '/dat';

        $tmpFolder = $this->dir . '/' . $authCode;
        if(is_dir($tmpFolder))
        {
            system('rm -rf ' . $tmpFolder);
        }
//        mkdir($packageDir . '/data', 0777, true);


        // cut PDF
        $PdfCutter = $this->getContainer()->get('vm_package_generator.pdf_cutter');
        $PdfCutter->cutPdf($path, $tmpFolder . '/tmp');

        $size = getimagesize($tmpFolder .'/tmp/jpg/page_1.jpg');

        $targetDataDir = ($type == 'json') ? $packageDir . '/pages' : $packageDir . '/swf';
        if(!is_dir($targetDataDir))
        {
            mkdir($targetDataDir, 0777, true);
        }
        if($type == 'json')
        {
            system('mv ' . $tmpFolder . '/tmp/jpg/*.* ' . $targetDataDir);
            $extension = 'json';
        }
        else
        {
            system('mv ' . $tmpFolder . '/tmp/swf/*.* ' . $targetDataDir);
            $extension = 'xml';
        }

        $StructureFactory = $this->getContainer()->get('vm_package_generator.export.structure_factory');
        $Structure = $StructureFactory->getStructure($extension);
        $Structure->setPageDimensions($size[0], $size[1]);
        file_put_contents($packageDir . '/structure.' . $extension, $Structure->get($targetDataDir, $authCode, $title));

        $zipFileName = $authCode . '_' . $type . '.zip';
        if($type == 'mobile')
        {
            $ManifestCreator = $this->getContainer()->get('vm_package_generator.export.manifest_creator');
            file_put_contents($packageDir . '/manifest.xml', $ManifestCreator->get($authCode, $title));

            mkdir($packageDir . '/files', 0777);
            copy(__DIR__ . '/../../Resources/export/icon.png', $packageDir .'/files/icon.png');
            copy($path, $packageDir .'/files/pdf.pdf');

            if(is_dir($svnDir))
            {
                system('cp -r ' . $packageDir . '/* ' . $svnDir);
                system('cd ' . $svnDir . ' && svn add * && svn commit -m "" && cd -');
            }

            system('rm -rf ' . $tmpFolder . '/tmp');
            system('mv ' . $tmpFolder . '/dat ' . $tmpFolder . '/data');
            system('mv ' . $tmpFolder . '/data/* ' . $tmpFolder . ' && rm -rf ' . $tmpFolder . '/data');
            system( 'cd ' . $tmpFolder . ' && /usr/local/bin/zip -qr ' . $tmpFolder . '/' . $zipFileName . ' ./');
            system('mv ' . $tmpFolder . '/' . $zipFileName . ' ' . $outputPath);
            system('rm -rf ' . $tmpFolder . '/*');
        }
        else if($type == 'xml')
        {
            if(!is_dir($packageDir . '/otherXmls'))
            {
                mkdir($packageDir . '/otherXmls', 0777);
            }
            file_put_contents($packageDir . '/otherXmls/toolbar.' . $extension, '<item>
  <toolbar onTop="false" type="Bottom" id="bottomtoolbar" hide_margin="51" width="570" height="51">
    <itemsGroup align="Left" shift="8" margin="10">
	  <textField x="10" y="0">Strona:</textField>
      <textInput id="input_1256" x="60" y="4" width="60" selectable="false">
        <text/>
        <listener type="CmdViewerSpreadChanged"/>
        <action type="click">{"Type":"CmdViewerLoadCustomSpreadByNumber"}</action>
      </textInput>
	  <icon id="icon_1273" x="140" y="0" type="iconZoom">
        <action type="click">{"Type":"CmdShowZoomDialog","File":"module_dialogsCommon.swf","Name":"DialogZoom_En", "Params":{"AllowMove":"true", "lock_bg":"false"}}</action>
      </icon>
      <spacer type="iconVSpacer" x="250" y="3"/>
      <icon id="icon_1286" x="250" y="0" type="iconNote">
        <title></title>
        <action type="click">{"Type":"CmdShowNoteDialog"}</action>
      </icon>
	  <spacer type="iconVSpacer" x="350" y="3"/>
      <icon id="icon_1275" x="350" y="0" type="iconPrint">
        <title></title>
        <action type="click">{"Type":"CmdShowFileDialog","File":"dialog_print.swf","Name":"DialogPrint"}</action>
      </icon>
      <spacer type="iconVSpacer" x="440" y="3"/>
      <icon id="icon_1296" x="440" y="0" type="iconExit">
        <title></title>
        <action type="click">{"Type":"CmdBackToShelf"}</action>
      </icon>
    </itemsGroup>
  </toolbar>
</item>');
            if(!$onlyContent)
            {
                system('cp -r ' . __DIR__ . '/../Resources/export/flash/* ' . $tmpFolder);
            }


            if(!$onlyContent)
            {
                system( 'cd ' . $tmpFolder . ' && /usr/local/bin/zip -qr ' .$tmpFolder . '/' . $zipFileName . ' ./');
            }
            else
            {
                system( 'cd ' . $tmpFolder . '/dat && /usr/local/bin/zip -qr ' .$tmpFolder . '/' . $zipFileName . ' ./');
            }
            system('mv ' .$tmpFolder . '/' . $zipFileName . ' ' . $outputPath);
            system('rm -rf ' . $tmpFolder . '/*');
        }
        else
        {
            if(!$onlyContent)
            {
                system('cp -r ' . __DIR__ . '/../Resources/export/html5/* ' . $this->dir);
            }


            system('rm -rf ' . $tmpFolder . '/tmp');
            system('mv ' . $tmpFolder . '/dat ' . $tmpFolder . '/data');
            if(!$onlyContent)
            {
                system( 'cd ' . $tmpFolder . ' && /usr/local/bin/zip -qr ' .$tmpFolder . '/' . $zipFileName . ' ./');
            }
            else
            {
                system( 'cd ' . $tmpFolder . '/data && /usr/local/bin/zip -qr ' .$tmpFolder . '/' . $zipFileName . ' ./');
            }
            system('mv ' .$tmpFolder . '/' . $zipFileName . ' ' . $outputPath);
            system('rm -rf ' . $tmpFolder . '/*');
            //            system('mv ' . $this->dir . ' ' . $outputPath . '/' . $authCode);
        }

        return $zipFileName;
    }


    /**
     * @return ContainerInterface
     */
    protected function getContainer()
    {
        return $this->Container;
    }
} 